/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __MYAPP_REGISTRY_HEADER_INCLUDED__
#define __MYAPP_REGISTRY_HEADER_INCLUDED__

#include <windows.h>
#include <tchar.h>
void	MyApp_Registry_InitialiseKey();
BOOL	MyApp_Registry_CheckKeyPresent();
void MyApp_Registry_CloseKey();


typedef struct
{
	LPCTSTR pExtensionKeyName;			/* e.g. ".dsk" */
	LPCTSTR pExtensionLinkKeyName;		/* e.g. "Arnold.DskFile" */
	LPCTSTR pExtensionDescription;		/* e.g. "Disk Image File" */
	int	nIconIndex;						/* e.g. index of icon in main file */
	LPCTSTR pApplicationPath;			/* e.g. c:\program files\arnold.exe" */
} EXTENSION_INFO;

void	RegisterExtension(const EXTENSION_INFO *pExtensionInfo, BOOL fOpenWith);

//new
int MyApp_Registry_GetValue(const TCHAR * Key, const TCHAR *ValueName);
BOOL MyApp_Registry_GetString(const TCHAR * Key, const TCHAR *ValueName, char *pBuffer);
BOOL MyApp_Registry_SetString(const TCHAR * Key, const TCHAR *ValueName, const TCHAR *ValueString);
BOOL MyApp_Registry_SetValue(const TCHAR * Key, const TCHAR *ValueName, int ValueData);
BOOL Settings_IsKeyPresent(char * key);


#endif
